/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	OffsetChain.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CEdit.h"
#include "CApplication.h"


HRESULT OffsetChain(ISet *lineSet, double offsetDistance, long offsetDirection)
{

	START_METHOD("OffsetChain")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	// Create an empty set of lines
	ISet *offsetChainSet = NULL;
	status = (GetCLASS(ObjectSet))->CreateAObjectSet(&offsetChainSet);
	CHECK_RETURN_STATUS(status)

	ILineChain *lineChain = NULL;
	status = (GetCLASS(LineChain))->CreateLineChain(CAST(IObjectOrSet, lineSet), &lineChain);
	CHECK_RETURN_STATUS(status)

	BOOL bRight = FALSE;
	BOOL bLeft = FALSE;

	if( offsetDirection == 1 || offsetDirection == 3 ) {
		bLeft = TRUE;
	}

	if( offsetDirection == 2 || offsetDirection == 3 ) {
		bRight = TRUE;
	}

	ISet *offsetLines = NULL;
	VARIANT_BOOL addToSketch = TRUE; 
	if(bRight) {
		status = lineChain->OffsetLines(activeSketch, offsetDistance, addToSketch, &offsetLines);
		CHECK_RETURN_STATUS(status)

		status = AddSet(offsetChainSet, offsetLines);
		CHECK_RETURN_STATUS(status)
	}

	if(bLeft) {
		status = lineChain->reverse();
		CHECK_RETURN_STATUS(status)

		status = lineChain->OffsetLines(activeSketch, offsetDistance, addToSketch, &offsetLines);
		CHECK_RETURN_STATUS(status)

		status = AddSet(offsetChainSet, offsetLines);
		CHECK_RETURN_STATUS(status)
	}

	// Apply AutoConstrain on the set of lines
	status = activeWorkplane->AutoConstrain(CAST(IObjectOrSet, offsetChainSet));
	CHECK_RETURN_STATUS(status)

	// Set the selection to the object set
	status = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, offsetChainSet));
	CHECK_RETURN_STATUS(status)

	END_METHOD("OffsetChain")
}
